unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure CapturaAreaTrab(NomeArq : String);
var
  Bitmap : TBitmap;
  DC : hDc;
  DesktopRect : TRect;
  DesktopCanvas : TCanvas;
  HoraAtu : DWord;
begin
// esconde a aplicao - no queremos que aparea na tela
  Application.MainForm.Hide;
// da 1/2 segundo para restaurar tela
  HoraAtu := GetTickCount;
  while GetTickCount-HoraAtu < 500 do
    Application.ProcessMessages;
  try
// pega um DC para a rea de trabalho
    DC := GetDC(GetDesktopWindow);
    try
// cria um canvas para rea de trabalho
      DesktopCanvas := TCanvas.Create;
// cria um bitmap para armazenar rea de trabalho
      Bitmap := TBitmap.Create;
      try
// deixa tamanho do bitmap igual ao da tela
        Bitmap.Width := Screen.Width;
        Bitmap.Height := Screen.Height;
// seta o Handle do canvas para o DC da rea de trabalho
        DesktopCanvas.Handle := DC;
        DeskTopRect := Rect(0,0,Screen.Width,Screen.Height);
// copia imagem da rea de trabalho para o bitmap
        Bitmap.Canvas.CopyRect(DeskTopRect,DeskTopCanvas,DeskTopRect);
// salva o bitmap
        Bitmap.SaveToFile(NomeArq);
      finally
        Bitmap.Free;
        DesktopCanvas.Free;
      end;
    finally
// libera o DC da rea de trabalho
      ReleaseDC(GetDesktopWindow,DC);
    end;
  finally
// restaura aplicao
    Application.MainForm.Show;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if Edit1.Text <> '' then
    CapturaAreaTrab(Edit1.Text);
end;

end.
